/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.quickrightclick_common_neoforge.features;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.quickrightclick_common_neoforge.config.ConfigHandler;
import com.natamus.quickrightclick_common_neoforge.data.Constants;
import com.natamus.quickrightclick_common_neoforge.data.Variables;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class ShulkerBoxFeature {
    public static boolean init(Level level, Player player, BlockPos playerPos, ItemStack handStack, InteractionHand hand, Block block) {
        if (!ConfigHandler.enableQuickShulkerBoxes) {
            return false;
        }
        ShulkerBoxBlock shulkerBoxBlock = (ShulkerBoxBlock)block;
        Direction playerDirection = player.getDirection();
        BlockPos shulkerPos = playerPos.above(2).relative(playerDirection, 0).immutable();
        if (!level.getBlockState(shulkerPos).getBlock().equals(Blocks.AIR)) {
            if (level.isClientSide()) {
                MessageFunctions.sendMessage((Player)player, (String)"Unable to open shulker box, location obstructed.", (ChatFormatting)ChatFormatting.DARK_GRAY);
            }
            return false;
        }
        BlockState blockState = (BlockState)block.defaultBlockState().setValue((Property)ShulkerBoxBlock.FACING, (Comparable)playerDirection);
        ShulkerBoxBlockEntity shulkerBoxBlockEntity = new ShulkerBoxBlockEntity(shulkerBoxBlock.getColor(), shulkerPos, blockState);
        shulkerBoxBlockEntity.setLevel(level);
        level.setBlock(shulkerPos, blockState, 3);
        level.setBlockEntity((BlockEntity)shulkerBoxBlockEntity);
        ItemContainerContents itemContainerContents = (ItemContainerContents)handStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        int i = 0;
        Iterator itemContainerIterator = itemContainerContents.stream().iterator();
        while (itemContainerIterator.hasNext()) {
            ItemStack nextStack = (ItemStack)itemContainerIterator.next();
            shulkerBoxBlockEntity.setItem(i, nextStack);
            ++i;
        }
        DataComponentMap.Builder dataComponentMapBuilder = DataComponentMap.builder();
        dataComponentMapBuilder.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"\u2800 ").append(handStack.getHoverName()));
        shulkerBoxBlockEntity.setComponents(dataComponentMapBuilder.build());
        handStack.shrink(1);
        String playerName = player.getName().getString();
        Variables.shulkerUsed.add(playerName);
        Variables.shulkerUsedHand.put(playerName, hand);
        player.openMenu((MenuProvider)shulkerBoxBlockEntity);
        return true;
    }

    public static ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, Block shulkerBoxBlock) {
        ItemStack itemStack = new ItemStack((ItemLike)shulkerBoxBlock.asItem());
        levelReader.getBlockEntity(blockPos, BlockEntityType.SHULKER_BOX).ifPresent(shulkerBoxBlockEntity -> ShulkerBoxFeature.saveToItem(shulkerBoxBlockEntity, itemStack, (HolderLookup.Provider)levelReader.registryAccess()));
        return itemStack;
    }

    public static void saveToItem(ShulkerBoxBlockEntity shulkerBoxBlockEntity, ItemStack itemStack, HolderLookup.Provider registryAccess) {
        try (ProblemReporter.ScopedCollector $$5 = new ProblemReporter.ScopedCollector(shulkerBoxBlockEntity.problemPath(), Constants.LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)$$5, (HolderLookup.Provider)registryAccess);
            shulkerBoxBlockEntity.saveCustomOnly((ValueOutput)tagValueOutput);
            shulkerBoxBlockEntity.removeComponentsFromTag((ValueOutput)tagValueOutput);
            BlockItem.setBlockEntityData((ItemStack)itemStack, (BlockEntityType)shulkerBoxBlockEntity.getType(), (TagValueOutput)tagValueOutput);
            itemStack.applyComponents(shulkerBoxBlockEntity.collectComponents());
        }
    }
}

